/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricutils.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class ModuleResolver
extends ClassLoader {
    private final Map<String, byte[]> modules;
    private final Map<String, byte[]> assets;

    public ModuleResolver(Map<String, byte[]> modules, Map<String, byte[]> assets) {
        super(Thread.currentThread().getContextClassLoader());
        this.modules = modules;
        this.assets = assets;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.modules.get(name);
        if (bytes == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] data = this.assets.get(name);
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        if (name.startsWith("/") && (data = this.assets.get(name.substring(1))) != null) {
            return new ByteArrayInputStream(data);
        }
        return super.getResourceAsStream(name);
    }
}

